
<?php $__env->startSection('content'); ?>
   
  <main id="main" class="main">
    
    <!-- Page Title -->
    <div class="pagetitle">
      <h1>Registos</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="<?php echo e(route('registo.index')); ?>">Registos</a></li>
          <li class="breadcrumb-item active">Registos</li>
        </ol>
      </nav>
    </div>
    <!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
            <div class="card-body">
              <h5 class="card-title">Registos</h5>
              <div class="row">
                  <div class="col-lg-8">
                      <?php if(session('status')): ?>
                          <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="bi bi-check-circle me-1"></i>
                            <?php echo e(session('status')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                          </div>
                      <?php endif; ?>
                  </div>
                  <div class="col-lg-4" style="text-align: right; padding-right: 2%">
                    <?php if($user->role_id==1 or $user->role_id==2): ?>
                        <a href="<?php echo e(route('registo.create')); ?>" data-bs-toggle="tooltip" data-bs-placement="top" title="Adicionar um novo registo." class="btn btn-dark"><i class="bi bi-folder-plus"></i></a>
                    <?php endif; ?>
                  </div>
              </div>


              <!-- Table with stripped rows -->
              <table class="table datatable responsive" >
                <thead>
                  <tr style="font-size: 10px">
                    <th></th>
                    <th>Categoria</th>
                    <th>Descrição</th>
                    <th>Departamento</th>
                    <th>Província</th>
                    <th>Município</th>
                    <th colspan="4">Acção</th>
                  </tr>
                </thead>
                <tbody>
                    <?php 
                        $counter=0; 
                    ?>
                    <?php $__currentLoopData = $registos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr> 
                        <td>
                            <?php if($Item->total_vistos>0): ?>
                              <a href="<?php echo e(route('registo.show', ['valor'=>$Item->id, 'ok'=>1])); ?>" data-bs-toggle="tooltip" data-bs-placement="top" title="Abrir a lista de <?php if ($Item->total_vistos==1){ echo 'visualização'; }else{echo 'visualizações'; } ?>">
                                <span class="badge bg-success"><i class="bi bi-check-circle me-1"></i> <?php echo e($Item->total_vistos); ?></span>
                              </a>
                            <?php else: ?>
                              <span class="badge bg-danger"><i class="bi bi-check-circle me-1"></i> <?php echo e($Item->total_vistos); ?></span>
                            <?php endif; ?>
                        </td>
                        <td class="" style="font-size: 10px"><?php echo e($Item->categoria); ?></td>
                        <td class="" style="font-size: 10px"><?php echo e($Item->descricao); ?> <br> <?php echo e($Item->nota); ?></td>
                        <td class="" style="font-size: 10px"><?php echo e($Item->departamento); ?></td>
                        <td class="" style="font-size: 10px"><?php echo e($Item->nome_provincia); ?></td>
                        <td class="" style="font-size: 10px"><?php echo e($Item->nome_municipio); ?></td>
                        <td style="width: 22%;">
                            <form style="display: inline-block;" action="<?php echo e(route('registo.visto', ['ok'=>1])); ?>" method="post">
                                <input type="hidden" name="valor" value="<?php echo e($Item->id); ?>">
                                <?php echo csrf_field(); ?>
                                <button data-bs-toggle="tooltip" data-bs-placement="top" title="Marcar como visto." type="submit" class="btn btn-sm btn-success"><i class="bi bi-check-circle"></i></button>
                            </form>
                            <a  <?php if($Item->anexo): ?> href="<?php echo e(url("storage/{$Item->anexo}" )); ?>" <?php else: ?> href="#" <?php endif; ?>  data-bs-toggle="tooltip" data-bs-placement="top" title="Abrir o anexo 1." type="button" class="btn btn-sm btn-dark"><i class="bi bi-paperclip"></i></a>
                            <a  <?php if($Item->anexo1): ?> href="<?php echo e(url("storage/{$Item->anexo1}" )); ?>" <?php else: ?> href="#" <?php endif; ?>  data-bs-toggle="tooltip" data-bs-placement="top" title="Abrir o anexo 2." type="button" class="btn btn-sm btn-dark"><i class="bi bi-paperclip"></i></a>
                            <?php if(($user->role_id=='1' or $user->role_id=='2') or ($user->id == $Item->user_id)): ?>
                                <a href="<?php echo e(route('registo.edit', ['valor'=>$Item->id, 'ok'=>1])); ?>" data-bs-toggle="tooltip" data-bs-placement="top" title="Alterar o registo." type="button" class="btn btn-sm btn-info"><i class="bi bi-pencil"></i></a>
                            <?php endif; ?>
                            <?php if(($user->role_id=='1' or $user->role_id=='2')): ?>
                                <form style="display: inline-block;" action="<?php echo e(route('registo.destroy', ['ok'=>1])); ?>" method="post">
                                  <input type="hidden" name="valor" value="<?php echo e($Item->id); ?>">
                                  <?php echo csrf_field(); ?>
                                  <?php echo method_field('DELETE'); ?>
                                  <button data-bs-toggle="tooltip" data-bs-placement="top" title="Deletar permanentemente este registo." type="submit" class="btn btn-sm btn-danger"><i class="bi bi-trash"></i></button>
                                </form>
                            <?php endif; ?>
                        
                        </td> 
                        
                         
                    </tr> 

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
              <!-- End Table with stripped rows -->

            </div>
          </div>

        </div>
      </div>
    </section>

  </main><!-- End #main -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projectos\controlav3\resources\views/registo/index.blade.php ENDPATH**/ ?>