<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Utilizadores') }}
        </h2>
    </x-slot>
    
    <div class="py-12 pt-10">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if ($user->role_id==1)
                
            <div class="w-full flex justify-end mb-4 pr-8">
                <a href="{{route('utilizador.create')}}" class="px-2 py-1 text-white border rounded border-green-900 bg-green-400 text-green transition duration-300 ease-in-out">
                    Novo Utilizador
                </a>
            </div>
                
            @endif
            
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <table class="w-full">
                        <thead class="border-b border-gray-700" >
                            <th class="font-bold text-left px-4 py-4">Nº</th>
                            <th class="font-bold text-left px-4 py-1">Foto</th>
                            <th class="font-bold text-left px-4 py-1">Nome</th>
                            <th class="font-bold text-left px-4 py-1">Email</th>
                            <th class="font-bold text-left px-4 py-1">Perfil</th> 
                             
                            <th class="font-bold text-left px-4 py-1">Criado em</th>
                            <th class="font-bold text-left px-4 py-1">Acção</th>
                        </thead>
                        <tbody>
                           <?php $counter=0; ?>
                           @forelse ($users as $Item)
                                <tr>
                                    <td class="font-normal px-4 py-2">{{++$counter}}</td>  
                                        <td class="font-normal px-4 py-2" style="width: 10%; height: 10%;">
                                            @if ($Item->photo==null or $Item->photo=='')
                                            
                                                <a href="{{ asset('assets/img/sem-foto.jpg') }}" target="_blank">
                                                    <img src="{{ asset('assets/img/sem-foto.jpg') }}" alt="Image" style="width: 50px; height: 50px;">
                                                </a>
                                           
                                        @else
                                           
                                                <a href="{{asset('assets/img/user/') }}/{{ $Item->photo }}" target="_blank" rel="noopener noreferrer">
                                                    <img src="{{asset('assets/img/user/') }}/{{ $Item->photo }}" style="width: 50px; height: 50px;">
                                                </a>
                                            
                                        @endif
                                    </td>
                                    <td class="font-normal px-4 py-2">{{$Item->name}}</td>
                                    <td class="font-normal px-4 py-2">{{$Item->userEmail}}</td>
                                    <td class="font-normal px-4 py-2">{{$Item->role}}</td>
                                    
                                    <td class="font-normal px-4 py-2">{{$Item->created_at}}<br>{{$Item->updated_at}}</td>
                                    <td class="font-normal px-4 py-2">
                                        <div class="flex flex-around gap-2">
                                            <a href="{{route('utilizador.show', ['valor'=>$Item->user_id, 'ok'=>1])}}" class="px-2 py-1 border rounded border-black bg-black text-white transition duration-300 ease-in-out">Detalhe</a>
                                            @if ($user->role_id==1)
                                                @if ($Item->estado_id!=1)
                                                    <form action="{{route('utilizador.activate', ['ok'=>1])}}" method="post">
                                                        <input type="hidden" name="valor" value="{{ $Item->user_id }}">
                                                        @csrf
                                                        <button class="px-2 py-1 border rounded border-green-900 bg-green-400 text-white transition duration-300 ease-in-out">Activar</button>
                                                    </form>
                                                @else
                                                    <form action="{{route('utilizador.deactivate', ['ok'=>1])}}" method="post">
                                                        <input type="hidden" name="valor" value="{{ $Item->user_id }}">
                                                        @csrf
                                                        <button class="px-2 py-1 border rounded border-yellow-600 bg-yellow-400 text-white transition duration-300 ease-in-out">Desactivar</button>
                                                    </form>
                                                @endif

                                                <form action="{{route('utilizador.destroy', ['ok'=>1])}}" method="post">
                                                    <input type="hidden" name="valor" value="{{ $Item->user_id }}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="px-2 py-1 border rounded border-red-900 bg-red-400 text-white transition duration-300 ease-in-out">Apagar</button>
                                                </form>
                                            @endif 
                                        </div>
                                    </td>
                                </tr> 
                            @empty
                                <tr><td colspan="5">Nenhum utilizador cadastrado...</td></tr> 
                            @endforelse
                            
                        </tbody>
                    </table>
                    <div class="mt-10">
                        {{$users->links()}}
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
