<x-app-layout>
    <x-slot name="header">
        <h4 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            @forelse ($registos as $Item) {{$Item->categoria}} {{' | '.$Item->descricao}} @break   @empty  {{ __('Registo sem Visibilidade. ') }}  @endforelse
        </h4>
    </x-slot>
        
      <div class="py-12 pt-10">
        
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
           <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                @if (session('status'))
                    <div class="w-full my-4 p-2" style="color: green">
                        {{ session('status') }}
                    </div>
                @endif  
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <table class="w-full">
                        <thead class="border-b border-gray-700" >
                            <th class="font-bold text-left px-4 py-4">Nº</th>
                            <th class="font-bold text-left px-4 py-1">Visto por</th>
                            <th class="font-bold text-left px-4 py-1">E-mail</th>
                            <th class="font-bold text-left px-4 py-1">Foto</th>
                            <th class="font-bold text-left px-4 py-1">Detalhes</th>
                        </thead>
                        <tbody>
                           <?php $counter=0; ?>
                           @forelse ($registos as $Item)
                                <tr> 
                                    <td class="font-normal px-4 py-2">{{$Item->id}}/{{$Item->departamento_id}}</td> 
                                    <td class="font-normal px-4 py-2">{{$Item->name}}</td>
                                    <td class="font-normal px-4 py-2">{{$Item->email}}</td>
                                    <td class="font-normal px-4 py-2">
                                        <img src="{{ url("storage/{$Item->photo}" ) }}" style="width: 50px; height: 50px;">
                                    </td>
                                    <td class="font-normal px-4 py-2">{{$Item->created_at}}</td>
                                </tr> 
                            @empty
                                <tr><td colspan="5">Registo não marcado como visto...</td></tr> 
                            @endforelse
                            
                        </tbody>
                    </table>
                    <div class="mt-10">
                        {{$registos->links()}}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
