@extends('../layouts.navigation')
@section('content')
   
<main id="main" class="main">

     <!-- Page Title -->
     <div class="pagetitle">
        <h1>Registos</h1>
        <nav>
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('registo.index') }}">Registos</a></li>
            <li class="breadcrumb-item active">Novo</li>
          </ol>
        </nav>
      </div>
      <!-- End Page Title -->
    <section class="section">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                    <h5 class="card-title">Novo Registo</h5>
                    <P>
                      @if (session('status'))
                          <div class="alert alert-success alert-dismissible fade show" role="alert">
                              {{ session('status') }}
                          <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                          </div>
                      @endif
                    </P>
                        <!-- Multi Columns Form -->
                        <form class="row g-3" method="POST" enctype="multipart/form-data" id="upload" action="{{route('registo.create')}}">
                            
                          <div class="col-md-4">
                              <label for="municipio" class="form-label">Município*</label>
                              <select value="{{ old('municipio') }}" class="form-control" required name="municipio" id="municipio">
                                  @forelse ($municipios as $item)
                                      <option value="{{$item->id}}">{{$item->nome}}</option>
                                  @empty
                                      <option @disabled(true) value="">Nenhum município cadastrado</option>
                                  @endforelse
                              </select>
                              @error('municipio') 
                                  <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                    {{ $message }}
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                  </div>
                              @enderror
                          </div>
                          <div class="col-md-4">
                            <label for="categoria" class="form-label">Categoria*</label>
                            <select value="{{ old('categoria') }}" class="form-control" required name="categoria" id="categoria">
                                @forelse ($categorias as $item)
                                    <option value="{{$item->id}}">{{$item->categoria}}</option>
                                @empty
                                    <option @disabled(true) value="">Nenhuma categoria cadastrado</option>
                                @endforelse
                                
                            </select>
                            @error('categoria') 
                                <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                    {{ $message }}
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @enderror
                        </div>
                        
                        <div class="col-md-4">
                            <label for="departamento" class="form-label">Departamento*</label>
                            <select value="{{ old('departamento') }}" class="form-control" required name="departamento" id="departamento">
                                @forelse ($departamentos as $item)
                                    <option value="{{$item->id}}">{{$item->departamento}}</option>
                                @empty
                                    <option @disabled(true) value="">Nenhum departamento cadastrado</option>
                                @endforelse
                                
                            </select>
                            @error('departamento') 
                                <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                    {{ $message }}
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="descricao" class="form-label">Descrição*</label>
                            <input placeholder="Descrição" class="form-control" max="100" type="text" name="descricao" id="descricao" value="{{ old('descricao') }}">
                            @error('descricao')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="descricao" class="form-label">Observação</label>
                            <input placeholder="Observação" class="form-control" type="text" name="nota" id="nota" value="{{ old('nota') }}">
                            @error('nota')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                          <label for="anexo" class="form-label">Anexo 1 (PDF, PNG, JPEG, JPG)</label>
                          <input class="form-control" type="file" name="anexo" id="anexo" >
                          @error('anexo')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                          @enderror
                      </div>

                      <div class="col-md-6">
                          <label for="anexo1" class="form-label">Anexo 2 (PDF, PNG, JPEG, JPG)</label>
                          <input class="form-control" type="file" name="anexo1" id="anexo1" >
                          @error('anexo1')
                              <div class="alert alert-danger bg-danger text-light border-0 alert-dismissible fade show" role="alert">
                                {{ $message }}
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                              </div>
                          @enderror
                      </div>
                      @csrf
                            <div class="text-center">
                                <button type="submit" class="btn btn-primary">Salvar</button>
                                <button type="reset" class="btn btn-secondary">Reset</button>
                            </div>
                        </form>
                        <!-- End Multi Columns Form -->

                    </div>
                </div>
            </div>
        </div>
    </section>

  </main>
  <!-- End #main -->

@endsection