<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Níveis de ensino') }}
        </h2>
    </x-slot>
        
    
    
      <div class="py-12 pt-10">
        
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if (/*$user->role_id==1 or $user->role_id==2*/ 1!=1)
                <div class="w-full flex justify-end mb-4 pr-8">
                    <a href="{{route('nivel.create')}}" class="px-2 py-1 text-white border rounded border-green-900 bg-green-400 text-green transition duration-300 ease-in-out">
                        Novo
                    </a>
                </div>
            @endif
            
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    @if (session('status'))
                        <div class="w-full my-4 p-2" style="color: green">
                            {{ session('status') }}
                        </div>
                    @endif
                    <table class="w-full">
                        <thead class="border-b border-gray-700" >
                            <th class="font-bold text-left px-4 py-4">Nº</th>
                            <th class="font-bold text-left px-4 py-1">Nível</th>
                            <th class="font-bold text-left px-4 py-1">Status</th>
                            @if ($user->role_id==1 or $user->role_id==2)
                                <th class="font-bold text-left px-4 py-1">Acção</th>
                            @endif
                        </thead>
                        <tbody>
                           <?php $counter=0;  ?>
                           @forelse ($niveis as $Item)
                                <tr>
                                    <td class="font-normal px-4 py-2">{{++$counter}}</td>  
                                    <td class="font-normal px-4 py-2">{{$Item->nivel}}</td>
                                    <td class="font-normal px-4 py-2" @if ($Item->status != 'Activo') @style("color:red")  @else  @style("color:green") @endif >{{$Item->status}}</td>
                                    @if ($user->role_id==1 or $user->role_id==2)
                                        <td class="font-normal px-4 py-2"> 
                                                @if ($Item->status != 'Activo')
                                                    <form action="{{route('nivel.activate')}}" method="post">
                                                        <input type="hidden" name="valor" value="{{ $Item->id }}">
                                                        @csrf
                                                        <button class="px-2 py-1 border rounded border-green-900 bg-green-400 text-white transition duration-300 ease-in-out">Activar</button>
                                                    </form>
                                                @else
                                                    <form action="{{route('nivel.deactivate')}}" method="post">
                                                        <input type="hidden" name="valor" value="{{ $Item->id }}">
                                                        @csrf
                                                        <button class="px-2 py-1 border rounded border-yellow-600 bg-yellow-400 text-white transition duration-300 ease-in-out">Desactivar</button>
                                                    </form>
                                                @endif
                                        </td>
                                    @endif 
                                </tr> 
                            @empty
                                <tr><td colspan="5">Nenhuma nível cadastrado...</td></tr> 
                            @endforelse
                            
                        </tbody>
                    </table>
                    <div class="mt-10">
                        {{$niveis->links()}}
                    </div>
                </div>
            </div>

            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg" style="margin-top: 50px">
                
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    @if (session('status_subnivel'))
                        <div class="w-full my-4 p-2" style="color: green">
                            {{ session('status_subnivel') }}
                        </div>
                    @endif
                    <table class="w-full">
                        <thead class="border-b border-gray-700" >
                            <th class="font-bold text-left px-4 py-4">Nº</th>
                            <th class="font-bold text-left px-4 py-1">Subínvel</th>
                            <th class="font-bold text-left px-4 py-1">Nível</th>
                            <th class="font-bold text-left px-4 py-1">Status</th>
                            @if ($user->role_id==1 or $user->role_id==2)
                                <th class="font-bold text-left px-4 py-1">Acção</th>
                            @endif
                        </thead>
                        <tbody>
                           <?php $counter=0;  ?>
                           @forelse ($subniveis as $Item)
                                <tr>
                                    <td class="font-normal px-4 py-2">{{++$counter}}</td> 
                                    <td class="font-normal px-4 py-2">{{$Item->subnivel}}</td> 
                                    <td class="font-normal px-4 py-2">{{$Item->nivel}}</td>
                                    <td class="font-normal px-4 py-2" @if ($Item->status != 'Activo') @style("color:red")  @else  @style("color:green") @endif >{{$Item->status}}</td>
                                    @if ($user->role_id==1 or $user->role_id==2)
                                        <td class="font-normal px-4 py-2"> 
                                                @if ($Item->status != 'Activo')
                                                    <form action="{{route('subnivel.activate')}}" method="post">
                                                        <input type="hidden" name="valor" value="{{ $Item->id }}">
                                                        @csrf
                                                        <button class="px-2 py-1 border rounded border-green-900 bg-green-400 text-white transition duration-300 ease-in-out">Activar</button>
                                                    </form>
                                                @else
                                                    <form action="{{route('subnivel.deactivate')}}" method="post">
                                                        <input type="hidden" name="valor" value="{{ $Item->id }}">
                                                        @csrf
                                                        <button class="px-2 py-1 border rounded border-yellow-600 bg-yellow-400 text-white transition duration-300 ease-in-out">Desactivar</button>
                                                    </form>
                                                @endif
                                        </td>
                                    @endif 
                                </tr> 
                            @empty
                                <tr><td colspan="5">Nenhuma nível cadastrado...</td></tr> 
                            @endforelse
                            
                        </tbody>
                    </table>
                    <div class="mt-10">
                        {{$subniveis->links()}}
                    </div>
                </div>
            </div>
            
        </div>


        
    </div>
</x-app-layout>
