<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Municípios') }}
        </h2>
    </x-slot>
        
      <div class="py-12 pt-10">
        
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            
            @if ($user->role_id==1 or $user->role_id==2 or $user->role_id==3)
                <div class="w-full flex justify-end mb-4 pr-8">
                    <a href="{{route('escola.index')}}" class="px-2 py-1 text-white border rounded border-black bg-black transition duration-300 ease-in-out">
                        Escolas
                    </a>
                    
                    <a href="{{route('parceiro.index')}}" class="px-2 py-1 text-white border rounded border-black bg-black transition duration-300 ease-in-out">
                        Parceiros
                    </a>
                    <a href="{{route('municipio.create')}}" class="px-2 py-1 text-white border rounded border-green-900 bg-green-400 text-green transition duration-300 ease-in-out">
                        Novo
                    </a>
                </div>
            @else
                <div class="w-full flex justify-end mb-4 pr-8">
                    <a href="{{route('escola.index')}}" class="px-2 py-1 text-white border rounded border-black bg-black transition duration-300 ease-in-out">
                        Escolas
                    </a>
                    
                    <a href="{{route('parceiro.index')}}" class="px-2 py-1 text-white border rounded border-black bg-black transition duration-300 ease-in-out">
                        Parceiros
                    </a>
                </div>

            @endif
            
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <table class="w-full">
                        <thead class="border-b border-gray-700" >
                            <th class="font-bold text-left px-4 py-4">Nº</th>
                            <th class="font-bold text-left px-4 py-1">Província</th>
                            <th class="font-bold text-left px-4 py-1">Município</th>
                            <th class="font-bold text-left px-4 py-1">Código</th>
                            <th class="font-bold text-left px-4 py-1">Responsável</th>
                            <th class="font-bold text-left px-4 py-1">Criado em</th>
                            <th class="font-bold text-left px-4 py-1">Acção</th>
                        </thead>
                        <tbody>
                           <?php $counter=0; ?>
                           @forelse ($municipios as $Item)
                                <tr>
                                    <td class="font-normal px-4 py-2">{{++$counter}}</td> 
                                    <td class="font-normal px-4 py-2">{{$Item->nomeprovincia}}</td> 
                                    <td class="font-normal px-4 py-2">{{$Item->nome}}</td>
                                    <td class="font-normal px-4 py-2">{{$Item->codigo}}</td>
                                    <td class="font-normal px-4 py-2">{{$Item->name}}</td>
                                    <td class="font-normal px-4 py-2">{{$Item->created_at}}<br>{{$Item->updated_at}}</td>
                                    <td class="font-normal px-4 py-2">
                                        <div class="flex flex-around gap-2">
                                            <a href="#" class="px-2 py-1 border rounded border-black bg-black text-white transition duration-300 ease-in-out">Turmas</a>
                                            <a href="{{route('escola.show', ['valor'=>$Item->id, 'ok'=>1])}}" class="px-2 py-1 border rounded border-black bg-black text-white transition duration-300 ease-in-out">Escolas</a>
                                            <a href="{{route('parceiro.show', ['valor'=>$Item->id, 'ok'=>1])}}" class="px-2 py-1 border rounded border-black bg-black text-white transition duration-300 ease-in-out">Parceiros</a>
                                            @if (($user->role_id==1 or $user->role_id==2) or $user->id == $Item->responsavelprovincia_id or $user->id == $Item->user_id)
                                                <a href="{{route('municipio.edit', ['valor'=>$Item->id, 'ok'=>1])}}" class="px-2 py-1 border rounded border-blue-900 bg-blue-400  text-white transition duration-300 ease-in-out">Alterar</a>
                                                <form action="{{route('municipio.destroy', ['ok'=>1])}}" method="post">
                                                    <input type="hidden" name="valor" value="{{ $Item->id }}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="px-2 py-1 border rounded border-red-900 bg-red-400 text-white transition duration-300 ease-in-out">Apagar</button>
                                                </form>
                                            
                                            @endif
                                            
                                        </div>
                                    </td>
                                </tr> 
                            @empty
                                <tr><td colspan="5">Nenhuma Provincia cadastrada...</td></tr> 
                            @endforelse
                            
                        </tbody>
                    </table>
                    <div class="mt-10">
                        {{$municipios->links()}}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
