<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Entidades') }}
        </h2>
    </x-slot>
    
    <div class="py-12 pt-10">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <table class="w-full">
                        <thead class="border-b border-gray-700">
                            <th class="font-bold text-left px-4 py-4">Nº</th>
                            <th class="font-bold text-left px-4 py-1">Nome</th>
                            <th class="font-bold text-left px-4 py-1">Criado em</th>
                            <th class="font-bold text-left px-4 py-1">Acção</th>
                        </thead>
                        <tbody>
                           <?php $counter=0;  ?>
                                <tr>
                                    <td class="font-normal px-4 py-2">{{++$counter}}</td>  
                                    <td class="font-normal px-4 py-2 w-[65%]">{{$Entidade->nome}}</td>
                                    <td class="font-normal px-4 py-2">{{$Entidade->created_at->format("d/m/Y h:i:s")}}<br>{{$Entidade->created_at->diffForHumans()}}</td>
                                    <td class="font-normal px-4 py-2 w-[15%]">
                                        <div class="flex flex-around gap-2">
                                            <a href="{{route('entidade.show', ['valor'=>$Entidade->id, 'ok'=>1])}}" class="px-2 py-1 border rounded border-black bg-black text-white transition duration-300 ease-in-out">Detalhe</a>
                                            @if ($user->role_id==1)
                                                <a href="{{route('entidade.edit', ['valor'=>$Entidade->id, 'ok'=>1])}}" class="px-2 py-1 border rounded border-blue-900 bg-blue-400  text-white transition duration-300 ease-in-out">Alterar</a>
                                                <form action="{{route('entidade.destroy', ['ok'=>1])}}" method="post">
                                                    <input type="hidden" name="valor" value="{{ $Entidade->id }}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button title="Ao deletar esta entidade, todos os dados relacionados a ela também serão eliminados em cascata. Esta acção é irreversível. Sugerimos que faça um backup dos dados antes de prosseguir." class="px-2 py-1 border rounded border-red-900 bg-red-400 text-white transition duration-300 ease-in-out">Apagar</button>
                                                </form>
                                            @endif
                                            

                                        </div>
                                    </td>
                                </tr> 
                        </tbody>
                    </table>
                    
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
