<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('numero_de_identidade',20)->nullable();
            $table->string('foto_da_identidade',255)->nullable();
            $table->string('iban',14)->nullable();
            $table->string('foto_do_iban',255)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('numero_de_identidade');
            $table->dropColumn('foto_da_identidade');
            $table->dropColumn('iban');
            $table->dropColumn('foto_do_iban');
        });
    }
};
