<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class entidade extends Model
{
    use HasFactory;
    // Atributos na BD que podem receber valores
    protected $fillable=['nome',  'descricao', 'sobre', 'telefone', 'email', 'fundacao', 'logotipo'];
    
    // Tem muitos usuários
    public function users():HasMany 
    {
        return $this->hasMany(User::class);
    }

    // Tem muitos provinces
    public function provinces():HasMany 
    {
        return $this->hasMany(Province::class);
    }

    
    
}
