<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Visto extends Model
{
    use HasFactory;

    protected $fillable=['descricao',  'anexo', 'anexo1', 'user_id', 'registo_id'];

    
    //Pertence um registo
    public function registo():BelongsTo
    {
        return $this->belongsTo(Registo::class);
    }

    //Pertence um registo
    public function user():BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
