<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class RegistoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            "municipio" => 'required|integer', 
           // "province" => 'required|integer',
            "descricao" => 'required|max:100',
            "nota" => 'nullable', 
            "categoria" =>'required|integer',
            "departamento" =>'required|integer',
            "anexo" => 'nullable|mimes:png,jpg,jpeg,pdf',  
            "anexo1" => 'nullable|mimes:png,jpg,jpeg,pdf',  
            // "anexo2" => 'nullable|mimes:png,jpg,jpeg,pdf',  
            // "anexo3" => 'nullable|mimes:png,jpg,jpeg,pdf',  
            //"estado" => 'nullable|max:100'
        ];
    }


    public function messages()
    {
     
        return [
                'required'=>'Este campo é obrigatório.',
                'max'=>'Este campo deve ter no máximo :max caracteres.',
            ];
    }
}
