<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class EscolaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'nome'=>'required|max:100',
            'numero'=>'nullable',
            'responsavel'=>'required|max:80',
            'telefone'=>'nullable|numeric',
            'email'=>'nullable|email|max:80',
            'photo' => 'mimes:png,jpg,jpeg,pdf'
        ];
    }


    public function messages()
    {
     
        return [
                'required'=>'Este campo é obrigatório.',
                'email' => 'O campo deve ser do tipo Email',
                'mimes' => 'Ficheiro inválido. O ficheiro deve ser do tipo png, jpg ou jpeg e deve ter no máximo 2048Mb'
            ];
    }
}
