<?php

namespace App\Http\Controllers;

use App\Models\Subnivei;
use Illuminate\Http\Request;

class SubniveiController extends Controller
{

    /**
     * Activate the user
     */
    public function activate_subnivel(Request $request){
        $user = auth()->user();
        if($user->role_id==1 or $user->role_id==2){
            $dados = $request->all();
            $niveis = Subnivei::findORFail($dados['valor']);
            $niveis->update(
                [
                    'status'=>'Activo',
                ]
            );
            return redirect()->back()->with('status_subnivel','Nível de ensino '.$niveis->nivel.' ativado com sucesso.');
            
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
    }

    /**
     * DeActivate the user
     */
    public function deactivate_subnivel(Request $request){
        
        $user = auth()->user();
        if($user->role_id==1 or $user->role_id==2){
            $dados = $request->all();
            $niveis = Subnivei::findORFail($dados['valor']);
            $niveis->update(
                [
                    'status'=>'Inactivo',
                ]
            );
            return redirect()->back()->with('status_subnivel','Nível de ensino '.$niveis->nivel.' desativado com sucesso.');
            ;
            
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Subnivei $subnivei)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Subnivei $subnivei)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Subnivei $subnivei)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Subnivei $subnivei)
    {
        //
    }
}
