<?php

namespace App\Http\Controllers;

use App\Http\Requests\ParceiroRequest;
use App\Models\Municipio;
use App\Models\Parceiro;
use App\Models\Province;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Nette\Utils\Strings;

use function PHPUnit\Framework\isInt;



class ParceiroController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        
        $user =  auth()->user(); 
        $parceiros = DB::table('parceiros')
            ->join('municipios', 'parceiros.municipio_id', '=', 'municipios.id')
            ->join('provinces', 'municipios.province_id', '=', 'provinces.id')
            ->join('entidades', 'municipios.entidade_id', '=', 'entidades.id')
            ->select('parceiros.*', 'provinces.nome as nome_provincia', 'provinces.user_id as responsavelprovincia_id', 
            'municipios.nome as nome_municipio',  'municipios.user_id as responsavelmunicipio_id', )
            ->where("entidades.id",$user->entidade_id)
            ->orderBy('nome_provincia','asc')
            ->orderBy('nome_municipio','asc')
            ->orderBy('nome','asc')
            ->paginate(10);
        // dd($parceiros);
        return view('parceiro.index', compact('parceiros','user'));
        
    }
     
   /**
     * Display the specified resource.
     */
    public function show(string $municipio_id)
    {
     
       if(isInt($municipio_id))
        { 
            $user =  auth()->user();
            $parceiros = DB::table('parceiros')
            ->join('municipios', 'parceiros.municipio_id', '=', 'municipios.id')
            ->join('provinces', 'municipios.province_id', '=', 'provinces.id')
            ->join('entidades', 'municipios.entidade_id', '=', 'entidades.id')
            ->select('parceiros.*', 'provinces.nome as nome_provincia', 'provinces.user_id as responsavelprovincia_id', 
            'municipios.nome as nome_municipio',  'municipios.user_id as responsavelmunicipio_id', )
            ->where(["parceiros.municipio_id" => $municipio_id, "entidades.id" => $user->entidade_id])
            ->orderBy('nome_provincia','asc')
            ->orderBy('nome_municipio','asc')
            ->orderBy('nome','asc')
            ->paginate(10); 
            return view('parceiro.index', compact('parceiros','user'));
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
         
       // dd($parceiros);
      
              
        
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        
        $user =  auth()->user();
        if($user->role_id==1 or $user->role_id==2){
            $municipios = DB::table('municipios')
            ->join('provinces', 'municipios.province_id', '=', 'provinces.id')
            ->join('entidades', 'municipios.entidade_id', '=', 'entidades.id')
            ->select('municipios.id as idmunicipio', 
            'provinces.nome as nome_provincia', 
            'municipios.nome as nome_municipio')
            ->where([ "entidades.id" => $user->entidade_id])
            ->orderBy('nome_provincia','asc')
            ->orderBy('nome_municipio','asc')
            ->get(); 

        }else{
            $municipios = DB::table('municipios')
            ->join('provinces', 'municipios.province_id', '=', 'provinces.id')
            ->join('entidades', 'municipios.entidade_id', '=', 'entidades.id')
            ->select('municipios.id as idmunicipio', 
            'provinces.nome as nome_provincia', 
            'municipios.nome as nome_municipio')
            ->where(["municipios.user_id" => $user->id,"provinces.user_id" => $user->id],null,null,'or')
            ->orderBy('nome_provincia','asc')
            ->orderBy('nome_municipio','asc')
            ->get();
        }
        return view('parceiro.create', compact('municipios'));
        
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(ParceiroRequest $request)
    {
            $user =  auth()->user();
            // dd($user);
             if($user->role_id<5){
                $dados = $request->all();
                $mun = Municipio::findOrfail($dados['municipio']);
                if($user->role_id>2){
                    $prov = Province::findOrfail($mun->province_id); 
                    if($mun->user_id!=$user->id and $prov->user_id != $user->id)
                    {
                        abort(403, 'Não autorizado.');
                        exit();
                    } 
                }
                 

                $file = $request->file('photo');
                if($file!=null){
                    // $path = $file->store('assets/img/parceiro');
                    $path = '';
                }else{
                    $path = '';
                }
                
                
                $parceiro = Parceiro::create(
                     [
                     'nome'=>$dados['nome'],
                     'codigo'=>$dados['codigo'],
                     'nomedoresponsavel'=>$dados['responsavel'],
                     'telefonedoresponsavel'=>$dados['telefone'],
                     'emaildoresponsavel'=>$dados['email'],
                     'logotipo'=>$path,
                     'municipio_id'=>$dados['municipio'],
                     // 'entidade_id'=>$Entidade->id,
                     // 'user_id'=>$responsavel->id, // responsável
                     ]
                 );
                  
                
                return redirect()->route('parceiro.create')->with('status','Novo parceiro adicionado com sucesso');
                 
             }else{
                 abort(403, 'Não autorizado.');
                 exit();
             }
        
    }

    

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(String $parceiroid)
    {
        //$parceiroid=$Request['valor'];
            
            
            if(isInt($parceiroid)){
                $parceiro = Parceiro::findOrfail($parceiroid);
            }else{
                abort(403, 'Não autorizado.');
                exit();
            }

            $user =  auth()->user();
            if($user->role_id<5){
                $mun = Municipio::findOrfail($parceiro->municipio_id);
                if($user->role_id>2){
                    $prov = Province::findOrfail($mun->province_id); 
                    if($mun->user_id!=$user->id and $prov->user_id != $user->id)
                    {
                        abort(403, 'Não autorizado.');
                        exit();
                    } 
                }
            }else{
                 abort(403, 'Não autorizado.');
                 exit();
            }

        if($user->role_id==1 or $user->role_id==2){
            $municipios = DB::table('municipios')
            ->join('provinces', 'municipios.province_id', '=', 'provinces.id')
            ->join('entidades', 'municipios.entidade_id', '=', 'entidades.id')
            ->select('municipios.id as idmunicipio', 
            'provinces.nome as nome_provincia', 
            'municipios.nome as nome_municipio')
            ->where([ "entidades.id" => $user->entidade_id])
            ->orderBy('nome_provincia','asc')
            ->orderBy('nome_municipio','asc')
            ->get(); 

        }else{
            $municipios = DB::table('municipios')
            ->join('provinces', 'municipios.province_id', '=', 'provinces.id')
            ->join('entidades', 'municipios.entidade_id', '=', 'entidades.id')
            ->select('municipios.id as idmunicipio', 
            'provinces.nome as nome_provincia', 
            'municipios.nome as nome_municipio')
            ->where(["municipios.user_id" => $user->id,"provinces.user_id" => $user->id],null,null,'or')
            ->orderBy('nome_provincia','asc')
            ->orderBy('nome_municipio','asc')
            ->get(); 
        }
        //dd($parceiro);
       return view('parceiro.edit', compact('municipios','parceiro'));
        
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(ParceiroRequest $request)
    {       
            $dados = $request->all();
            $parceiroid=$dados['parceiro'];
            if(isInt($parceiroid)){
                $parceiro = Parceiro::findOrfail($parceiroid);
            }else{
                abort(403, 'Não autorizado.');
                exit();
            }
            $user =  auth()->user();
            if($user->role_id<5){
                $mun = Municipio::findOrfail($parceiro->municipio_id);
                if($user->role_id>2){
                    $prov = Province::findOrfail($mun->province_id); 
                    if($mun->user_id!=$user->id and $prov->user_id != $user->id)
                    {
                        abort(403, 'Não autorizado.');
                        exit();
                    } 
                }

                $file = $request->file('photo');
                if($file!=null){
                    // $path = $file->store('assets/img/parceiro');
                    $path = '';
                    $parceiro ->update(
                     [
                     'nome'=>$dados['nome'],
                     'codigo'=>$dados['codigo'],
                     'nomedoresponsavel'=>$dados['responsavel'],
                     'telefonedoresponsavel'=>$dados['telefone'],
                     'emaildoresponsavel'=>$dados['email'],
                     'logotipo'=>$path,
                     'municipio_id'=>$dados['municipio'],
                     // 'entidade_id'=>$Entidade->id,
                     // 'user_id'=>$responsavel->id, // responsável
                     ] 
                 );
                }else{
                    $parceiro ->update(
                     [
                     'nome'=>$dados['nome'],
                     'codigo'=>$dados['codigo'],
                     'nomedoresponsavel'=>$dados['responsavel'],
                     'telefonedoresponsavel'=>$dados['telefone'],
                     'emaildoresponsavel'=>$dados['email'],
                     'municipio_id'=>$dados['municipio'],
                     // 'entidade_id'=>$Entidade->id,
                     // 'user_id'=>$responsavel->id, // responsável
                     ]);
                }
                
                return redirect()->back()->with('status','Parceiro actualizado com sucesso!');

             }else{
                 abort(403, 'Não autorizado.');
                 exit();
             }

    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $Request)
    {
            $parceiroid=$Request['valor'];
            if(isInt($parceiroid)){
                $parceiro = Parceiro::findOrfail($parceiroid);
            }else{
                abort(403, 'Não autorizado.');
                exit();
            }
            $user =  auth()->user();
            if($user->role_id<5){
                $mun = Municipio::findOrfail($parceiro->municipio_id);
                if($user->role_id>2){
                    $prov = Province::findOrfail($mun->province_id); 
                    if($mun->user_id!=$user->id and $prov->user_id != $user->id)
                    {
                        abort(403, 'Não autorizado.');
                        exit();
                    } 
                }
                $parceiro->delete(); 
                return redirect()->back()->with('status','Parceiro '.$parceiro->nome.' eliminado com sucesso!');

             }else{
                 abort(403, 'Não autorizado.');
                 exit();
             }
        
    
    }
}
