<?php

namespace App\Http\Controllers;

use App\Http\Requests\EscolaRequest;
use App\Models\Escola;
use App\Models\Municipio;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use function PHPUnit\Framework\isInt;

class EscolaController extends Controller
{
     /**
     * Display a listing of the resource.
     */
    public function index()
    {
        
        $user =  auth()->user(); 
        $escolas = DB::table('escolas')
            ->join('municipios', 'escolas.municipio_id', '=', 'municipios.id')
            ->join('provinces', 'municipios.province_id', '=', 'provinces.id')
            ->join('entidades', 'municipios.entidade_id', '=', 'entidades.id')
            ->select('escolas.*', 'provinces.nome as nome_provincia', 'provinces.user_id as responsavelprovincia_id', 
            'municipios.nome as nome_municipio',  'municipios.user_id as responsavelmunicipio_id', )
            ->where("entidades.id",$user->entidade_id)
            ->orderBy('nome_provincia','asc')
            ->orderBy('nome_municipio','asc')
            ->orderBy('nome','asc')
            ->paginate(10);
        
            return view('escola.index', compact('escolas','user'));
        
    }
     
   /**
     * Display the specified resource.
     */
    public function show(string $municipio_id)
    {
     
       if(isInt($municipio_id))
        { 
            
            $user =  auth()->user();
            
            $escolas = DB::table('escolas')
            ->join('municipios', 'escolas.municipio_id', '=', 'municipios.id')
            ->join('provinces', 'municipios.province_id', '=', 'provinces.id')
            ->join('entidades', 'municipios.entidade_id', '=', 'entidades.id')
            ->select('escolas.*', 'provinces.nome as nome_provincia', 'provinces.user_id as responsavelprovincia_id', 
            'municipios.nome as nome_municipio',  'municipios.user_id as responsavelmunicipio_id', )
            ->where(["escolas.municipio_id" => $municipio_id, "entidades.id" => $user->entidade_id])
            ->orderBy('nome_provincia','asc')
            ->orderBy('nome_municipio','asc')
            ->orderBy('nome','asc')
            ->paginate(10); 
            
            return view('escola.index', compact('escolas','user'));
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
         
       
              
        
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        
        $user =  auth()->user();
        if(1/*$user->role_id==1 or $user->role_id==2*/){
            $municipios = DB::table('municipios')
            ->join('provinces', 'municipios.province_id', '=', 'provinces.id')
            ->join('entidades', 'municipios.entidade_id', '=', 'entidades.id')
            ->select('municipios.id as idmunicipio', 
            'provinces.nome as nome_provincia', 
            'municipios.nome as nome_municipio')
            ->where([ "entidades.id" => $user->entidade_id])
            ->orderBy('nome_provincia','asc')
            ->orderBy('nome_municipio','asc')
            ->get(); 

        }
        /*
        else{
            $municipios = DB::table('municipios')
            ->join('provinces', 'municipios.province_id', '=', 'provinces.id')
            ->join('entidades', 'municipios.entidade_id', '=', 'entidades.id')
            ->select('municipios.id as idmunicipio', 
            'provinces.nome as nome_provincia', 
            'municipios.nome as nome_municipio')
            ->where(["municipios.user_id" => $user->id,"provinces.user_id" => $user->id],null,null,'or')
            ->orderBy('nome_provincia','asc')
            ->orderBy('nome_municipio','asc')
            ->get();

        }
        */
        return view('escola.create', compact('municipios'));
        
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(EscolaRequest $request)
    {
            $user =  auth()->user();
            $dados = $request->all();
            $mun = Municipio::findOrfail($dados['municipio']);
            $file = $request->file('photo');
            if($file!=null){
                // $path = $file->store('assets/img/escola');
                $path = '';
            }else{
                $path = '';
            }
                
            $parceiro = escola::create(
                     [
                        'nome'=>$dados['nome'],
                        'numerodaescola'=>$dados['codigo'],
                        'nomedoresponsavel'=>$dados['responsavel'],
                        'telefonedoresponsavel'=>$dados['telefone'],
                        'emaildoresponsavel'=>$dados['email'],
                        'logotipo'=>$path,
                        'municipio_id'=>$dados['municipio'],
                        // 'entidade_id'=>$Entidade->id,
                        'user_id'=>$user->id, // Escola criada por
                     ]
            );
                  
                
                return redirect()->route('escola.create')->with('status','Nova escola adicionada com sucesso');
           
             
        
    }

    

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(String $escolaid)
    {
        if(isInt($escolaid)){
                $escola = escola::findOrfail($escolaid);
        }else{
                abort(403, 'Não autorizado.');
                exit();
        }
        $user =  auth()->user();
        $mun = Municipio::findOrfail($escola->municipio_id);
        $municipios = DB::table('municipios')
            ->join('provinces', 'municipios.province_id', '=', 'provinces.id')
            ->join('entidades', 'municipios.entidade_id', '=', 'entidades.id')
            ->select('municipios.id as idmunicipio', 
            'provinces.nome as nome_provincia', 
            'municipios.nome as nome_municipio')
            ->where([ "entidades.id" => $user->entidade_id])
            ->orderBy('nome_provincia','asc')
            ->orderBy('nome_municipio','asc')
            ->get(); 
        return view('escola.edit', compact('municipios','escola'));
        
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(EscolaRequest $request)
    {       
            $dados = $request->all();
            $escolaid=$dados['escola'];
            if(isInt($escolaid)){
                $escola = escola::findOrfail($escolaid);
            }else{
                abort(403, 'Não autorizado.');
                exit();
            }
            $user =  auth()->user();
            $mun = Municipio::findOrfail($escola->municipio_id);
            $file = $request->file('photo');
                if($file!=null){
                    // $path = $file->store('assets/img/escola');
                    $path = '';
                    $escola ->update(
                    [
                     'nome'=>$dados['nome'],
                     'codigo'=>$dados['codigo'],
                     'nomedoresponsavel'=>$dados['responsavel'],
                     'telefonedoresponsavel'=>$dados['telefone'],
                     'emaildoresponsavel'=>$dados['email'],
                     'logotipo'=>$path,
                     'municipio_id'=>$dados['municipio'],
                     'user_id'=>$user->id, // responsável
                    ] 
                 );
                }else{
                    $escola ->update(
                    [
                     'nome'=>$dados['nome'],
                     'codigo'=>$dados['codigo'],
                     'nomedoresponsavel'=>$dados['responsavel'],
                     'telefonedoresponsavel'=>$dados['telefone'],
                     'emaildoresponsavel'=>$dados['email'],
                     'municipio_id'=>$dados['municipio'],
                     'user_id'=>$user->id, // responsável
                    ]);
                }
                
                return redirect()->back()->with('status','escola actualizado com sucesso!');


    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $Request)
    {
            $parceiroid=$Request['valor'];
            if(isInt($parceiroid)){
                $parceiro = Parceiro::findOrfail($parceiroid);
            }else{
                abort(403, 'Não autorizado.');
                exit();
            }
            $user =  auth()->user();
            if($user->role_id<5){
                $mun = Municipio::findOrfail($parceiro->municipio_id);
                if($user->role_id>2){
                    $prov = Province::findOrfail($mun->province_id); 
                    if($mun->user_id!=$user->id and $prov->user_id != $user->id)
                    {
                        abort(403, 'Não autorizado.');
                        exit();
                    } 
                }
                $parceiro->delete(); 
                return redirect()->back()->with('status','Parceiro '.$parceiro->nome.' eliminado com sucesso!');

             }else{
                 abort(403, 'Não autorizado.');
                 exit();
             }
        
    
    }
}
