<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


class DashboardController extends Controller
{
    function index(Request $request){
        
        $user = auth()->user();
        $idEntidade = $user->entidade_id;
        $RegistoPorDepartamento = $this->RegistoPorDepartamento($idEntidade);
        // ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']
        // [120, 200, 150, 80, 70, 110, 130], 
        $RegistoPorCategoria = $this->RegistoPorCategoria($idEntidade);
        $anos = DB::table('anos')->get();
        $provincias = DB::table('provinces')->get();
        $municipios = DB::table('municipios')->get();
        $turmas = DB::table('alfabetizadoresturmas')->get();
        $resultados = $this->getAproveitamentos($request);

       return view('dashboard',compact('anos','provincias','municipios','turmas','resultados','RegistoPorDepartamento','RegistoPorCategoria','user'));
    }

    public function RegistoPorDepartamento($idEntidade){
        $dados = DB::table('departamentos')
                ->leftJoin('registos', 'departamentos.id', '=', 'registos.departamento_id')
                ->select('departamentos.cod_dpto', 'departamentos.id',
                 DB::raw('COUNT(departamentos.id) as qnt')
                )
               ->where("departamentos.entidade_id",$idEntidade)
                ->groupBy('departamentos.cod_dpto', 'departamentos.id')
                ->orderBy('departamentos.id')
                ->get();
        // dd($dados);
        return $dados;
    }

    public function RegistoPorCategoria($idEntidade){
        $dados = DB::table('categorias')
                ->leftJoin('registos', 'categorias.id', '=', 'registos.categoria_id')
                ->select('categorias.categoria',
                 DB::raw('COUNT(registos.id) as qnt')
                )
                ->where("categorias.entidade_id",$idEntidade)
                ->groupBy('categorias.categoria')
                ->orderBy('categorias.id')
                ->get();
        //  dd($dados);
        return $dados;
    }


    public function getAproveitamentos(Request $request) {
        
        $query = DB::table('municipios as m')
            ->select(
                'p.nome as provincia',
                'm.nome as municipio',
                DB::raw("COALESCE(a.anolectivo, 'Sem Ano') as anolectivo"),
                DB::raw("COALESCE(SUM(ap.total_matriculados_mf), 0) as total_matriculados_mf"),
                DB::raw("COALESCE(SUM(ap.total_matriculados_f), 0) as total_matriculados_f"),
                DB::raw("COALESCE(SUM(ap.total_aprovados_mf), 0) as total_aprovados_mf"),
                DB::raw("COALESCE(SUM(ap.total_aprovados_f), 0) as total_aprovados_f"),
                DB::raw("COALESCE(SUM(ap.total_reprovados_mf), 0) as total_reprovados_mf"),
                DB::raw("COALESCE(SUM(ap.total_reprovados_f), 0) as total_reprovados_f"),
                DB::raw("COALESCE(SUM(ap.total_desistentes_mf), 0) as total_desistentes_mf"),
                DB::raw("COALESCE(SUM(ap.total_desistentes_f), 0) as total_desistentes_f")
            )
            ->leftJoin('alfabetizadoresturmas as at', 'm.id', '=', 'at.municipio_id')
            ->leftJoin('anos as a', 'at.ano_id', '=', 'a.id')
            ->leftJoin('aproveitamentos as ap', 'at.id', '=', 'ap.alfabetizadoresturma_id')
            ->leftJoin('provinces as p', 'm.province_id', '=', 'p.id');
    
        // **Filtros opcionais**
        if ($request->filled('ano_id')) {
            $query->where('a.id', $request->ano_id);
        }
    
        if ($request->filled('provincia_id')) {
            $query->where('p.id', $request->provincia_id);
        }
    
        if ($request->filled('municipio_id')) {
            $query->where('m.id', $request->municipio_id);
        }
    
        if ($request->filled('turma_id')) {
            $query->where('at.id', $request->turma_id);
        }
    
        $dados = $query
            ->groupBy('p.nome','m.nome', 'a.anolectivo')
            ->orderByDesc('a.anolectivo')
            ->orderByDesc('total_matriculados_mf')
            ->get();
        
        return $dados;
    }
    
}






